<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://"
			+ request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/mta/css/mySet.css" />
<script src="<%=request.getContextPath()%>/resources/pickadate3_5_6/lib/picker.js"></script>
<script src="<%=request.getContextPath()%>/resources/pickadate3_5_6/lib/picker.date.js"></script>
<script src="<%=request.getContextPath()%>/resources/pickadate3_5_6/lib/picker.time.js"></script>
<script src="<%=request.getContextPath()%>/resources/pickadate3_5_6/lib/legacy.js"></script>
<script src="<%=request.getContextPath()%>/resources/pickadate3_5_6/lib/translations/zh_CN.js"></script>
<script src="<%=request.getContextPath()%>/resources/js/date/WdatePicker.js" type="text/javascript"></script>
<script src="<%= request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript" charset="utf-8"></script>
<script src="<%= request.getContextPath()%>/resources/js/mta/P010myset.js" type="text/javascript" language="javascript"></script>
<script type="text/javascript">
	var page_select_index=-1;
	var language="<%=session.getAttribute("language")%>"; 
	if (language.indexOf('en') > -1) {
		document.write("<script src='" + baseUrl + "/resources/js/mta_en/P010myset.js'><\/script>");
	} else {
		// 默认中文
		document.write("<script src='" + baseUrl + "/resources/js/mta/P010myset.js'><\/script>");
	}
	
</script>
</head>
<body>
	<div id="header">
		<c:import url="header.jsp"></c:import>
	</div>
	<div id="personalMain" class="w">
		<div id="leftNav" class="l">
			<c:import url="personalCenter.jsp"></c:import>
		</div>
		<div id="mainRight" class="r">
			<div class="title">
				<span class="title_back l"></span>
				<h2 class="l">
					<!-- 个人设置 -->
					<spring:message code="label.center.myset"/>
				</h2>
			</div>
			<div class="info">
				<form id="userForm" action="<%= request.getContextPath()%>/mta/P010/saveSucces.html" method="post">
					<ul class="list">
						<li>
							<span class="l">
								<!--用户名 -->
								<spring:message code="label.login.userholder"/>
							</span>
							<input type="hidden" name="userid" id="userid" value="${user.userid}" />
							<input type="text" name="username" disabled="disabled" id="userid" value="${user.username}" class="l" />
						</li>
						<li>
							<span class="l">
								<!--新密码 -->
								<spring:message code="label.center.newpwd"/>
							</span>
							<input type="text" name="newPassWord" id="newPassWord" maxlength="30" value="" class="l" />
						</li>
						<li>
							<span class="l">
								<!--新密码确认 -->
								<spring:message code="label.center.newpwdconfirm"/>
							</span>
							<input type="text" name="newPassWordCheck" id="newPassWordCheck" maxlength="30" value="" class="l" />
							<div class="l error" id="newPassWordSpan"></div>
						</li>
						<li>
							<span class="l">
								<!--真实姓名 -->
								<spring:message code="label.center.realname"/>
							</span>
							<input type="text" name="realname" disabled="disabled" id="" value="${user.realname}" class="l" />
						</li>
						<li>
							<span class="l">
								<!--昵称 -->
								<spring:message code="label.center.nickname"/>
							</span>
							<input type="text" name="nickname" id="" value="${user.nickname}" class="l" />
						</li>
						<li>
							<span class="l">
								<!--性别 -->
								<spring:message code="label.center.gender"/>
							</span>
							<c:choose>
								<c:when test="${user.gender==true}">
									<input class="radio" type="radio" name="gender" id="" value="1" checked="checked" />
									 <!--男 -->
									<spring:message code="lable.user.sex.man"/>
									<input class="radio" type="radio" name="gender" id="" value="0" />
									 <!--女 -->
									<spring:message code="lable.user.sex.women"/>
								</c:when>
								<c:otherwise>
									<input class="radio" type="radio" name="gender" id="" value="1" />
									<!--男 -->
									<spring:message code="lable.user.sex.man"/> 
									<input class="radio" type="radio" name="gender" id="" value="0" checked="checked" />
									<!--女 -->
									<spring:message code="lable.user.sex.women"/>
								</c:otherwise>
							</c:choose>
						</li>
						<li>
							<span class="l">
								<!--出生年月 -->
								<spring:message code="lable.center.birthday"/>
							</span>
							<input type="text" name="birthdayDate" id="birthdayDate" value="${user.birthdayStr}" class="l" onfocus="window.WdatePicker({dateFmt: 'yyyy-MM-dd'})" readonly="readonly" />
							<div class="l error" id="birthdaySpan"></div>
						</li>
						<li>
							<span class="l">
								<!--身份证 -->
								<spring:message code="lable.center.idcard"/>
							</span>
							<input type="text" name="idcard" id="idcard" value="${user.idcard}" maxlength="18" class="l" />
							<div class="l error" id="idcardSpan"></div>
						</li>
						<li>
							<span class="l">
								<!--邮箱 -->
								<spring:message code="lable.center.email"/>
							</span>
							<input type="email" name="email" id="youxiang" value="${user.email}" maxlength="50" class="l" />
							<div class="l error" id="yxSpan"></div>
						</li>
						<li>
							<span class="l">
								<!--电话 -->
								<spring:message code="lable.center.tel"/>
							</span>
							<input type="text" name="tel" id="dianhua" value="${user.tel}" class="l" />
							<div class="l error" id="dhSpan"></div>
						</li>
						<li>
							<span class="l">
								<!--部门 -->
								<spring:message code="lable.center.group"/>
							</span>
							<select name="groupid" id="groupId" class="l">
								<c:forEach items="${groupList}" var="groupList" varStatus="p">
									<option style="font-size: 14px;" value="${groupList.groupid}" <c:if test="${groupList.groupid==user.groupid}"> selected="selected"</c:if>>${groupList.groupname}</option>
								</c:forEach>
							</select>
						</li>
						<li>
							<span class="l">
								<!--职位 -->
								<spring:message code="lable.center.position"/>
							</span>
							<select name="positionid" id="positionId" class="l">
								<c:forEach items="${positionList}" var="positionList" varStatus="p">
									<option style="font-size: 14px;" value="${positionList.positionId}" <c:if test="${positionList.positionId==user.positionid}"> selected="selected"</c:if>>${positionList.name}</option>
								</c:forEach>
							</select>
						</li>
					</ul>
					<input type="submit" onclick="userFormSubmit();" name="submit" id="submit" value="保存" />
				</form>
			</div>
		</div>
	</div>
	<div id="footer">
		<c:import url="footer.jsp"></c:import>
	</div>
	<div id="mark"></div>
	<div id="messageDiv">
		<span class="close r">X</span>
		<div class="message">hihi</div>
	</div>
</body>
</html>